def polygon_area(points):
    n = len(points)
    area = 0
    for i in range(n):
        j = (i + 1) % n
        area += points[i][0] * points[j][1] - points[i][1] * points[j][0]
    return abs(area) // 2


def convex_hull(points):

    points = sorted(points)

    upper = []
    for p in points:
        while len(upper) >= 2 and cross_product(upper[-2], upper[-1], p) <= 0:
            upper.pop()
        upper.append(p)

    lower = []
    for p in reversed(points):
        while len(lower) >= 2 and cross_product(lower[-2], lower[-1], p) <= 0:
            lower.pop()
        lower.append(p)

    return upper[:-1] + lower[:-1]


def cross_product(o, a, b):
    return (a[0] - o[0]) * (b[1] - o[1]) - (a[1] - o[1]) * (b[0] - o[0])


def solve():
    N = int(input())
    points = [tuple(map(int, input().split())) for _ in range(N)]


    full_hull = convex_hull(points)


    min_area = float('inf')

    for i in range(N):
        reduced_points = points[:i] + points[i + 1:]
        reduced_hull = convex_hull(reduced_points)
        area = polygon_area(reduced_hull)
        min_area = min(min_area, area)

    print(min_area)

solve()